
<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
  <div class="col-md-12" id="intro">
    <div class="card shadow-lg border-0">
      <div class="card-header">
        <h3 class="card-title mb-0">
          Prepaid / Postpaid / DTH Recharge API
        </h3>
      </div>

      <div class="card-body">

        <!-- API URL -->
        <div class="mb-4">
          <h6 class="text-primary fw-bold mb-2">
            Complete URL For Recharge <span class="text-secondary">(For Prepaid, Postpaid, and DTH)</span>
          </h6>
          <div class="mt-2">
            <span class="me-2">Method: GET</span>
            <div class="bg-light border rounded p-3 mt-2">
              <code class="text-dark">
                https://pay2bill.in/WebAPI/ProcessRecharge?AccessToken=<span class="text-danger">GyWmb5eJNpumU4VMn3Wpi9TyGmBJrgax</span>&amp;NumberToRecharge=1234567890&amp;OperatorID=1&amp;Amount=10&amp;ReferenceID=124
              </code>
            </div>
          </div>
        </div>

        <!-- Request Parameters -->
        <div class="mb-4">
          <h6 class="text-primary fw-bold mb-2">Request Parameters Description</h6>
          <div class="table-responsive shadow-sm rounded">
            <table class="table table-bordered align-middle mb-0">
              <thead class="table-light">
                <tr>
                  <th>Parameter Name</th>
                  <th>Details</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td><b>AccessToken</b></td>
                  <td>
                    <span class="text-danger fw-bold">GyWmb5eJNpumU4VMn3Wpi9TyGmBJrgax</span>
                    <small class="text-muted">— Access token (available after IP verification)</small>
                  </td>
                </tr>
                <tr>
                  <td><b>NumberToRecharge</b></td>
                  <td><span class="text-danger fw-bold">1234567890</span> <small class="text-muted">— Mobile or DTH number to recharge</small></td>
                </tr>
                <tr>
                  <td><b>OperatorID</b></td>
                  <td><span class="text-danger fw-bold">1</span> <small class="text-muted">— Check operator codes under <b>Operator Check</b> menu</small></td>
                </tr>
                <tr>
                  <td><b>Amount</b></td>
                  <td><span class="text-danger fw-bold">10</span> <small class="text-muted">— Amount to be charged</small></td>
                </tr>
                <tr>
                  <td><b>ReferenceID</b></td>
                  <td><span class="text-danger fw-bold">124</span> <small class="text-muted">— Your unique reference ID for each recharge</small></td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>

        <!-- Success Response -->
        <div class="mb-4">
          <h6 class="text-primary fw-bold">Recharge Response — <span class="text-success">Success</span></h6>
          <div class="bg-light border rounded p-3 mt-2">
            <code class="text-dark">{"Errors":[],"APITransactionID":"TRRCG151","Status":"success","RechargedNumber":"1234567890","Amount":10.0,"OperatorID":1,"IsRequestSuccess":true}</code>
          </div>
        </div>

        <!-- Failure Response -->
        <div class="mb-4">
          <h6 class="text-primary fw-bold">Recharge Response — <span class="text-danger">Failure</span></h6>
          <div class="bg-light border rounded p-3 mt-2">
            <code class="text-dark">{"Errors":["Duplicate Reference ID"],"APITransactionID":"","Status":"failed","RechargedNumber":"","Amount":null,"OperatorID":null,"IsRequestSuccess":false}</code>
          </div>
        </div>

        <!-- Response Parameters -->
        <div>
          <h6 class="text-primary fw-bold mb-2">Response Parameters Description</h6>
          <div class="table-responsive shadow-sm rounded">
            <table class="table table-bordered align-middle mb-0">
              <thead class="table-light">
                <tr>
                  <th>Parameter Name</th>
                  <th>Details</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td><b>APITransactionID</b></td>
                  <td><span class="text-danger fw-bold">164</span> <small class="text-muted">— Our unique transaction ID</small></td>
                </tr>
                <tr>
                  <td><b>Status</b></td>
                  <td>
                    <span class="badge bg-success">success</span>
                    <span class="badge bg-danger">failed</span>
                    <span class="badge bg-warning text-dark">pending</span>
                    <small class="text-muted d-block mt-1">Recharge status could be one of these.</small>
                  </td>
                </tr>
                <tr>
                  <td><b>RechargedNumber</b></td>
                  <td><span class="text-danger fw-bold">1234567890</span> <small class="text-muted">— Number for which recharge was requested</small></td>
                </tr>
                <tr>
                  <td><b>Amount</b></td>
                  <td><span class="text-danger fw-bold">10</span> <small class="text-muted">— Requested recharge amount</small></td>
                </tr>
                <tr>
                  <td><b>OperatorID</b></td>
                  <td><span class="text-danger fw-bold">1</span> <small class="text-muted">— Operator code used in request</small></td>
                </tr>
                <tr>
                  <td><b>IsRequestSuccess</b></td>
                  <td><span class="text-success fw-bold">true</span> <small class="text-muted">— Indicates request success (not the recharge result)</small></td>
                </tr>
                <tr>
                  <td><b>Errors[]</b></td>
                  <td><small class="text-muted">Array of error messages, if any.</small></td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>

<style>
  code {
    font-family: "Fira Code", monospace;
    white-space: pre-wrap;
    word-break: break-word;
  }
  .card-title i {
    vertical-align: middle;
  }
  .table th, .table td {
    vertical-align: middle !important;
  }
</style>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('APIDocumentation.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\maxpay\resources\views\APIDocumentation\mobile_recharge.blade.php ENDPATH**/ ?>