
<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
<div class="col-md-12" id="balance-check">
  <div class="card card-light">
    <div class="card-header">
      <h4 class="card-title mb-0 fw-bold">Balance Check API</h4>
    </div>
    <div class="card-body">
      <div class="row">
        <!-- Description -->
        <div class="col-md-12">
          <b class="description text-primary">
            Complete URL for checking the user's balance
          </b>
        </div>

        <!-- API Method and Example URL -->
        <div class="col-md-12">
          <div class="form-group mt-2">
            <span class="label2 label2-sm label2-info">Method - GET</span>
            <div class="shadow-sm p-2 mt-2 url-baar rounded bg-light">
              <span>
                https://pay2bill.in/WebAPI/CheckBalance?
                <br>AccessToken=GyWmb5eJNpumU4VMn3Wpi9TyGmBJrgax
              </span>
            </div>
          </div>
        </div>

        <!-- Request Parameters -->
        <div class="col-md-12 mt-4 mb-3">
          <b class="description text-primary">Request Parameters Description :</b>
          <div class="responsive-table">
            <table class="table">
              <thead class="bg-light">
                <tr>
                  <th>Parameter Name</th>
                  <th>Details</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <th>AccessToken</th>
                  <td>
                    <strong class="text-danger">GyWmb5eJNpumU4VMn3Wpi9TyGmBJrgax</strong>
                    <span class="description">[Access token will be available after verifying IP]</span>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>

        <!-- Success Response -->
        <div class="col-md-12 mt-3">
          <div class="form-group">
            <span class="description text-primary">Balance Check Response [success]</span>
            <div class="shadow-sm p-2 mt-2 url-baar rounded bg-light">
              <span>
                {"Errors":[],"CurrentWalletBalance":970.00,"IsRequestSuccess":true}
              </span>
            </div>
          </div>
        </div>

        <!-- Failure Response -->
        <div class="col-md-12 mt-3">
          <div class="form-group">
            <span class="description text-primary">Balance Check Response [failure]</span>
            <div class="shadow-sm p-2 mt-2 url-baar rounded bg-light">
              <span>
                {"Errors":["Invalid Access Token"],"CurrentWalletBalance":0.0,"IsRequestSuccess":false}
              </span>
            </div>
          </div>
        </div>

        <!-- Response Parameters -->
        <div class="col-md-12 mt-4">
          <b class="description text-primary">Response Parameters Description :</b>
          <div class="responsive-table">
            <table class="table">
              <thead class="bg-light">
                <tr>
                  <th>Parameter Name</th>
                  <th>Details</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <th>CurrentWalletBalance</th>
                  <td>
                    <strong class="text-danger">970.00</strong>
                    <span class="description">[Current wallet balance of the user]</span>
                  </td>
                </tr>
                <tr>
                  <th>IsRequestSuccess</th>
                  <td>
                    <strong class="text-success">true</strong>
                    <span class="description">
                      [Returns true for successful requests and false for failed requests (not recharge status)]
                    </span>
                  </td>
                </tr>
                <tr>
                  <th>Errors[]</th>
                  <td>
                    <span class="description">
                      [String array containing error messages, if any]
                    </span>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>


</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('APIDocumentation.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\maxpay\resources\views/APIDocumentation/balance_check.blade.php ENDPATH**/ ?>