
<?php $__env->startSection('content'); ?>
<div class="container-xxl flex-grow-1 container-p-y">
<div class="col-md-12" id="intro">
  <div class="card shadow-sm border-0">
    <div class="card-header bg-light">
      <h4 class="card-title mb-0 fw-bold">Callback API</h4>
    </div>

    <div class="card-body">
      <div class="row g-4">
        <!-- Info Section -->
        <div class="col-12">
          <p class="fw-semibold text-primary">
            We will hit this URL once the status of the Recharge/Payment is changed.
          </p>
          <p class="text-muted mb-3">
            <strong>Note:</strong> We will pass Parameters &amp; Response ourselves. Do not add those manually.
          </p>
        </div>

        <!-- URL Section -->
        <div class="col-12">
          <span class="text-dark">Method - GET</span>
          <div class="bg-light p-2 mt-2 rounded border">
            <code class="text-break d-block">
              http://yourdomain.com/call_back_url?<br>
              APITransactionID=1234&amp;Status=success&amp;ConsumerNumber=1234567890&amp;Amount=10.00&amp;OperatorID=1&amp;ReferenceID=1234
            </code>
          </div>
        </div>

        <!-- Response Table -->
        <div class="col-12">
          <p class="fw-semibold text-primary mb-2">Response Parameters Description :</p>
          <div class="table-responsive">
            <table class="table table-bordered align-middle">
              <thead class="table-light">
                <tr>
                  <th>Parameter Name</th>
                  <th>Details</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td><b>APITransactionID</b></td>
                  <td>
                    <span class="text-danger fw-semibold">164</span>
                    <small class="text-muted"> [This is our unique Transaction ID]</small>
                  </td>
                </tr>
                <tr>
                  <td><b>Status</b></td>
                  <td>
                    <span class="text-success fw-semibold">success</span>
                    <small class="text-muted">
                      [Recharge status — possible values:
                      <span class="badge bg-success">success</span> |
                      <span class="badge bg-danger">failed</span> |
                      <span class="badge bg-warning text-dark">pending</span>]
                    </small>
                  </td>
                </tr>
                <tr>
                  <td><b>ConsumerNumber</b></td>
                  <td>
                    <span class="text-danger fw-semibold">1234567890</span>
                    <small class="text-muted"> [Consumer number or recharged number]</small>
                  </td>
                </tr>
                <tr>
                  <td><b>Amount</b></td>
                  <td>
                    <span class="text-danger fw-semibold">10</span>
                    <small class="text-muted"> [Amount for which the recharge was requested]</small>
                  </td>
                </tr>
                <tr>
                  <td><b>OperatorID</b></td>
                  <td>
                    <span class="text-danger fw-semibold">1</span>
                    <small class="text-muted"> [Operator code used during the request]</small>
                  </td>
                </tr>
                <tr>
                  <td><b>ReferenceID</b></td>
                  <td>
                    <span class="text-danger fw-semibold">1234</span>
                    <small class="text-muted"> [Your unique Reference ID for every recharge]</small>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div> <!-- /row -->
    </div> <!-- /card-body -->
  </div> <!-- /card -->
</div>

</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('APIDocumentation.layout', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\maxpay\resources\views/APIDocumentation/callback.blade.php ENDPATH**/ ?>