@extends('Admin.layout')
@section('content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card p-4">
            <h4 class="mb-4">Add Master Distributor</h4>
        <form action="#" method="POST">
            @csrf

            <!-- Personal Info -->
            <h6 class="fw-semibold mb-3 text-muted">Personal Info</h6>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">First Name</label>
                    <input type="text" class="form-control rounded-3" name="first_name" placeholder="John" value="{{ old('first_name') }}">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Last Name</label>
                    <input type="text" class="form-control rounded-3" name="last_name" placeholder="Doe" value="{{ old('last_name') }}">
                </div>
            </div>

            <!-- Company Info -->
            <h6 class="fw-semibold mb-3 text-muted mt-4">Company Info</h6>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Company Name</label>
                    <input type="text" class="form-control rounded-3" name="company_name" placeholder="Company Name" value="{{ old('company_name') }}">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Address</label>
                    <input type="text" class="form-control rounded-3" name="address" placeholder="Address" value="{{ old('address') }}">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">State Name</label>
                    <select class="form-select rounded-3" name="state_name">
                        <option value="">Select State</option>
                    </select>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Select Pin Codes To Map</label>
                    <select class="form-select rounded-3" name="pin_codes[]" multiple>
                        <option value="">Select</option>
                    </select>
                </div>
            </div>

            <!-- Contact Info -->
            <h6 class="fw-semibold mb-3 text-muted mt-4">Contact Info</h6>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Phone Number</label>
                    <input type="tel" class="form-control rounded-3" name="phone_number" placeholder="202 555 0111" value="{{ old('phone_number') }}">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Email</label>
                    <input type="email" class="form-control rounded-3" name="email" placeholder="Address" value="{{ old('email') }}">
                </div>
                <div class="col-md-12 mb-3">
                    <label class="form-label">WhatsApp Number</label>
                    <input type="tel" class="form-control rounded-3" name="whtasapp_number" placeholder="202 555 0111" value="{{ old('whtasapp_number') }}">
                </div>
            </div>

            <!-- Commission Package Info -->
            <h6 class="fw-semibold mb-3 text-muted mt-4">Commission Package Info</h6>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Commission Package</label>
                    <input type="text" class="form-control rounded-3" name="commission_package" value="{{ old('commission_package', 'Default Package') }}" placeholder="Default Package">
                </div>
            </div>

            <!-- Account Info -->
            <h6 class="fw-semibold mb-3 text-muted mt-4">Account Info</h6>
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">User Name</label>
                    <input type="text" class="form-control rounded-3" name="user_name" placeholder="John.Doe" value="{{ old('user_name') }}">
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">Password</label>
                    <input type="password" class="form-control rounded-3" name="password" placeholder="Password">
                </div>
            </div>

            <!-- Buttons -->
            <div class="mt-4 d-flex gap-3">
                <button type="submit" class="btn btn-primary rounded-3 px-4 py-2">Save Changes</button>
                <button type="button" class="btn btn-light text-muted border rounded-3 px-4 py-2">Cancel</button>
            </div>
        </form>
        </div>
    </div>
@endsection



