@extends('APIDocumentation.layout')
@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
<div class="col-md-12" id="intro">
  <div class="card shadow-sm border-0">
    <div class="card-header">
      <h5 class="card-title mb-0">Status Check API</h5>
    </div>
    <div class="card-body">
      <div class="row">
        <!-- URL Section -->
        <div class="col-12">
          <p class="fw-semibold text-primary">Complete URL to Check the Status of Recharge or Bill Payment</p>
          <div class="mb-3">
            <span class="text-dark">Method - GET</span>
            <div class="bg-light p-2 rounded mt-2 border">
              <code class="text-break">
                https://pay2bill.in/WebAPI/CheckStatus?AccessToken=GyWmb5eJNpumU4VMn3Wpi9TyGmBJrgax&amp;ReferenceID=1234
              </code>
            </div>
          </div>
        </div>

        <!-- Request Parameters -->
        <div class="col-12 mb-4">
          <p class="fw-semibold text-primary mb-2">Request Parameters Description :</p>
          <div class="table-responsive">
            <table class="table table-bordered align-middle">
              <thead class="table-light">
                <tr>
                  <th>Parameter Name</th>
                  <th>Details</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td><b>AccessToken</b></td>
                  <td>
                    <span class="text-danger fw-semibold">GyWmb5eJNpumU4VMn3Wpi9TyGmBJrgax</span>
                    <small class="text-muted"> [Access token will be available after verifying IP]</small>
                  </td>
                </tr>
                <tr>
                  <td><b>ReferenceID</b></td>
                  <td>
                    <span class="text-danger fw-semibold">124</span>
                    <small class="text-muted"> [Your unique reference ID for every recharge]</small>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>

        <!-- Response Success -->
        <div class="col-12 mb-4">
          <p class="fw-semibold text-primary">Status Check Response [Success]</p>
          <div class="bg-light p-2 rounded border">
            <code class="text-break d-block">
              {"Errors":[],"APITransactionID":"1234","Status":"success","ConsumerNumber":"1234567890","Amount":10.00,"OperatorID":1,"IsRequestSuccess":true}
            </code>
          </div>
        </div>

        <!-- Response Failure -->
        <div class="col-12 mb-4">
          <p class="fw-semibold text-primary">Status Check Response [Failure]</p>
          <div class="bg-light p-2 rounded border">
            <code class="text-break d-block">
              {"Errors":["Invalid Reference ID"],"APITransactionID":"","Status":"","ConsumerNumber":"","Amount":null,"OperatorID":null,"IsRequestSuccess":false}
            </code>
          </div>
        </div>

        <!-- Response Description -->
        <div class="col-12">
          <p class="fw-semibold text-primary mb-2">Response Parameters Description :</p>
          <div class="table-responsive">
            <table class="table table-bordered align-middle">
              <thead class="table-light">
                <tr>
                  <th>Parameter Name</th>
                  <th>Details</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td><b>APITransactionID</b></td>
                  <td><span class="text-danger fw-semibold">164</span> <small class="text-muted"> [Unique transaction ID from server]</small></td>
                </tr>
                <tr>
                  <td><b>Status</b></td>
                  <td>
                    <span class="text-success fw-semibold">success</span>
                    <small class="text-muted">
                      [Recharge status — possible values:
                      <span class="badge bg-success">success</span> |
                      <span class="badge bg-danger">failed</span> |
                      <span class="badge bg-warning text-dark">pending</span>]
                    </small>
                  </td>
                </tr>
                <tr>
                  <td><b>ConsumerNumber</b></td>
                  <td><span class="text-danger fw-semibold">1234567890</span> <small class="text-muted"> [Consumer number or recharge number]</small></td>
                </tr>
                <tr>
                  <td><b>Amount</b></td>
                  <td><span class="text-danger fw-semibold">10</span> <small class="text-muted"> [Amount requested]</small></td>
                </tr>
                <tr>
                  <td><b>OperatorID</b></td>
                  <td><span class="text-danger fw-semibold">1</span> <small class="text-muted"> [Operator code used during request]</small></td>
                </tr>
                <tr>
                  <td><b>IsRequestSuccess</b></td>
                  <td><span class="text-success fw-semibold">true</span> <small class="text-muted"> [Indicates if the request succeeded (not recharge status)]</small></td>
                </tr>
                <tr>
                  <td><b>Errors[]</b></td>
                  <td><small class="text-muted"> [Array of error messages if any]</small></td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div> <!-- /row -->
    </div> <!-- /card-body -->
  </div> <!-- /card -->
</div>

</div>

@endsection