@extends('APIDocumentation.layout')
@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
    <div class="col-md-12" id="operator-code">
  <div class="card shadow-sm border-0">
    <div class="card-header bg-light">
      <h3 class="card-title mb-0">Operator Code Fetch API</h3>
    </div>
    <div class="card-body">
      <div class="row">
        
        <!-- Description -->
        <div class="col-md-12">
          <b class="description text-primary">
            Complete URL for fetching operator codes for recharge and payment
          </b>
        </div>

        <!-- API Method and URL -->
        <div class="col-md-12 mt-3">
          <div class="form-group">
            <span class="badge bg-info text-dark">Method - GET</span>
            <div class="bg-light border rounded p-2 mt-2">
              <code>
                https://pay2bill.in/WebAPI/GetOperatorInfo?
                <br>AccessToken=GyWmb5eJNpumU4VMn3Wpi9TyGmBJrgax
              </code>
            </div>
          </div>
        </div>

        <!-- Request Parameters -->
        <div class="col-md-12 mt-4">
          <b class="description text-primary">Request Parameters Description :</b>
          <div class="table-responsive mt-2">
            <table class="table table-bordered align-middle">
              <thead class="table-light">
                <tr>
                  <th>Parameter Name</th>
                  <th>Details</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <th>AccessToken</th>
                  <td>
                    <strong class="text-danger">GyWmb5eJNpumU4VMn3Wpi9TyGmBJrgax</strong>
                    <span class="description">
                      [Access token will be available after verifying IP]
                    </span>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>

        <!-- Success Response -->
        <div class="col-md-12 mt-4">
          <span class="description text-primary">Response [success]</span>
          <div class="bg-light border rounded p-2 mt-2">
            <code>
              {"OperatorData":[{"OperatorCode":"14","OperatorName":"Airtel","Category":"Prepaid Mobile"},
              {"OperatorCode":"22","OperatorName":"Airtel","Category":"Postpaid Mobile"},
              {"OperatorCode":"12","OperatorName":"Airtel TV","Category":"DTH Recharge"}],
              "Errors":[],"IsRequestSuccess":true}
            </code>
          </div>
        </div>

        <!-- Failure Response -->
        <div class="col-md-12 mt-4">
          <span class="description text-primary">Response [failure]</span>
          <div class="bg-light border rounded p-2 mt-2">
            <code>
              {"OperatorData":[],"Errors":["Invalid Access Token"],"IsRequestSuccess":false}
            </code>
          </div>
        </div>

        <!-- Response Parameters -->
        <div class="col-md-12 mt-4">
          <b class="description text-primary">Response Parameters Description :</b>
          <div class="table-responsive mt-2">
            <table class="table table-bordered align-middle">
              <thead class="table-light">
                <tr>
                  <th>Parameter Name</th>
                  <th>Details</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <th>OperatorCode</th>
                  <td>
                    <strong class="text-danger">1</strong>
                    <span class="description">
                      [Operator ID to pass in Recharge or Bill Pay request]
                    </span>
                  </td>
                </tr>
                <tr>
                  <th>OperatorName</th>
                  <td>
                    <strong class="text-danger">Airtel</strong>
                    <span class="description">[Operator Name]</span>
                  </td>
                </tr>
                <tr>
                  <th>Category</th>
                  <td>
                    <strong class="text-danger">Mobile Prepaid</strong>
                    <span class="description">
                      [Operator Category (Prepaid Mobile, Postpaid Mobile, DTH Recharge etc.)]
                    </span>
                  </td>
                </tr>
                <tr>
                  <th>IsRequestSuccess</th>
                  <td>
                    <strong class="text-success">true</strong>
                    <span class="description">
                      [Returns true for successful requests and false for failed requests]
                    </span>
                  </td>
                </tr>
                <tr>
                  <th>Errors[]</th>
                  <td>
                    <span class="description">
                      [This is a string array which returns the error messages]
                    </span>
                  </td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>

      </div>
    </div>
  </div>
</div>

</div>

@endsection
