@extends('APIDocumentation.layout')
@section('content')
<div class="container-xxl flex-grow-1 container-p-y">
  <div class="col-md-12" id="intro">
    <div class="card shadow-lg border-0">
      <div class="card-header">
        <h5 class="card-title mb-0"> Bill Payments API
        </h5>
      </div>

      <div class="card-body">
        <!-- BILL FETCH SECTION -->
        <section class="mb-5">
          <h5 class="text-primary fw-bold mb-3">Complete URL for Bill Fetch</h5>
          <span class="text-dark">Method: GET</span>
          <div class="bg-light border rounded p-3 mt-2">
            <code class="text-dark">
              https://pay2bill.in/WebAPI/FetchBill?AccessToken=<span class="text-danger">GyWmb5eJNpumU4VMn3Wpi9TyGmBJrgax</span>&amp;BillerType=WATER&amp;OperatorID=1&amp;ConsumerNumber=1234567890&amp;MobileNumber=91234567890
            </code>
          </div>

          <h6 class="text-primary fw-bold mt-4">Bill Fetch Request Parameters</h6>
          <div class="table-responsive shadow-sm rounded mt-2">
            <table class="table table-bordered align-middle mb-0">
              <thead class="table-light">
                <tr><th>Parameter Name</th><th>Details</th></tr>
              </thead>
              <tbody>
                <tr><td><b>AccessToken</b></td><td><span class="text-danger fw-bold">GyWmb5eJNpumU4VMn3Wpi9TyGmBJrgax</span> <small class="text-muted">— Access token (after IP verification)</small></td></tr>
                <tr><td><b>BillerType</b></td><td><span class="text-danger fw-bold">WATER</span> <small class="text-muted">— FASTAG | ELECTRICITY | LANDLINE | GAS | WATER | BROADBAND | CABLETV | INSURANCE</small></td></tr>
                <tr><td><b>OperatorID</b></td><td><span class="text-danger fw-bold">1</span> <small class="text-muted">— Operator code (see Operator Check menu)</small></td></tr>
                <tr><td><b>ConsumerNumber</b></td><td><span class="text-danger fw-bold">1234567890</span> <small class="text-muted">— Consumer number to fetch bill</small></td></tr>
                <tr><td><b>MobileNumber</b></td><td><span class="text-danger fw-bold">9123456789</span> <small class="text-muted">— Consumer mobile number</small></td></tr>
              </tbody>
            </table>
          </div>

          <div class="mt-4">
            <h6 class="text-primary fw-bold">Bill Fetch Response — <span class="text-success">Success</span></h6>
            <div class="bg-light border rounded p-3 mt-2">
              <code class="text-dark">{"BillInfo":{"ConsumerNumberOrBillNumber":"1234567890","CustomerName":"Demo Customer","CustomerEmail":"customer@mail.com","CustomerPhone":"1234567890","BillGenerationDate":"01/01/2023","DueDate":"01/01/2023","AmountToPay":100.0,"IpayIdFromAPI":"1234567"},"Errors":[],"IsRequestSuccess":true}</code>
            </div>
          </div>

          <div class="mt-4">
            <h6 class="text-primary fw-bold">Bill Fetch Response — <span class="text-danger">Failure</span></h6>
            <div class="bg-light border rounded p-3 mt-2">
              <code class="text-dark">{"BillInfo":{"ConsumerNumberOrBillNumber":"","CustomerName":"","CustomerEmail":"","CustomerPhone":"","BillGenerationDate":"","DueDate":"","AmountToPay":0.0,"IpayIdFromAPI":""},"Errors":["Failed to fetch bill info"],"IsRequestSuccess":false}</code>
            </div>
          </div>

          <h6 class="text-primary fw-bold mt-4">Bill Fetch Response Parameters</h6>
          <div class="table-responsive shadow-sm rounded mt-2">
            <table class="table table-bordered align-middle mb-0">
              <thead class="table-light">
                <tr><th>Parameter Name</th><th>Details</th></tr>
              </thead>
              <tbody>
                <tr><td><b>ConsumerNumberOrBillNumber</b></td><td><span class="text-danger fw-bold">1234567890</span> <small class="text-muted">— Consumer number requested</small></td></tr>
                <tr><td><b>CustomerName</b></td><td><span class="text-danger fw-bold">Demo Customer</span> <small class="text-muted">— Consumer’s full name</small></td></tr>
                <tr><td><b>CustomerEmail</b></td><td><span class="text-danger fw-bold">user@mail.com</span> <small class="text-muted">— Consumer email (optional)</small></td></tr>
                <tr><td><b>CustomerPhone</b></td><td><span class="text-danger fw-bold">1234567890</span> <small class="text-muted">— Consumer phone (optional)</small></td></tr>
                <tr><td><b>BillGenerationDate</b></td><td><span class="text-danger fw-bold">01/01/2023</span> <small class="text-muted">— Date when bill was generated</small></td></tr>
                <tr><td><b>DueDate</b></td><td><span class="text-danger fw-bold">30/01/2023</span> <small class="text-muted">— Bill due date</small></td></tr>
                <tr><td><b>AmountToPay</b></td><td><span class="text-danger fw-bold">100</span> <small class="text-muted">— Payable amount</small></td></tr>
                <tr><td><b>IpayIdFromAPI</b></td><td><span class="text-danger fw-bold">1234</span> <small class="text-muted">— Additional parameter (optional)</small></td></tr>
                <tr><td><b>IsRequestSuccess</b></td><td><span class="text-success fw-bold">true</span> <small class="text-muted">— Indicates request success</small></td></tr>
                <tr><td><b>Errors[]</b></td><td><small class="text-muted">— Array of error messages</small></td></tr>
              </tbody>
            </table>
          </div>
        </section>

        <hr class="my-5">

        <!-- BILL PAYMENT SECTION -->
        <section>
          <h5 class="text-primary fw-bold mb-3">Complete URL for Bill Payment</h5>
           <span class="text-dark">Method: GET</span>
          <div class="bg-light border rounded p-3 mt-2">
            <code class="text-dark">
              https://pay2bill.in/WebAPI/ProcessBillPayment?AccessToken=<span class="text-danger">GyWmb5eJNpumU4VMn3Wpi9TyGmBJrgax</span>&amp;BillerType=WATER&amp;OperatorID=1&amp;ConsumerNumber=1234567890&amp;Amount=100&amp;ReferenceID=1234&amp;MobileNumber=91234567890
            </code>
          </div>

          <h6 class="text-primary fw-bold mt-4">Bill Payment Request Parameters</h6>
          <div class="table-responsive shadow-sm rounded mt-2">
            <table class="table table-bordered align-middle mb-0">
              <thead class="table-light">
                <tr><th>Parameter Name</th><th>Details</th></tr>
              </thead>
              <tbody>
                <tr><td><b>AccessToken</b></td><td><span class="text-danger fw-bold">GyWmb5eJNpumU4VMn3Wpi9TyGmBJrgax</span> <small class="text-muted">— Access token (after IP verification)</small></td></tr>
                <tr><td><b>BillerType</b></td><td><span class="text-danger fw-bold">WATER</span> <small class="text-muted">— FASTAG | ELECTRICITY | LANDLINE | GAS | WATER | BROADBAND | CABLETV | INSURANCE</small></td></tr>
                <tr><td><b>OperatorID</b></td><td><span class="text-danger fw-bold">1</span> <small class="text-muted">— Operator code</small></td></tr>
                <tr><td><b>ConsumerNumber</b></td><td><span class="text-danger fw-bold">1234567890</span> <small class="text-muted">— Consumer number to pay bill</small></td></tr>
                <tr><td><b>MobileNumber</b></td><td><span class="text-danger fw-bold">9123456789</span> <small class="text-muted">— Consumer mobile number</small></td></tr>
                <tr><td><b>Amount</b></td><td><span class="text-danger fw-bold">100</span> <small class="text-muted">— Amount to pay</small></td></tr>
                <tr><td><b>ReferenceID</b></td><td><span class="text-danger fw-bold">1234</span> <small class="text-muted">— Your unique reference ID</small></td></tr>
              </tbody>
            </table>
          </div>

          <div class="mt-4">
            <h6 class="text-primary fw-bold">Bill Payment Response — <span class="text-success">Success</span></h6>
            <div class="bg-light border rounded p-3 mt-2">
              <code class="text-dark">{"Errors":[],"APITransactionID":"TRRCG151","Status":"success","ConsumerNumber":"1234567890","Amount":100.0,"OperatorID":1,"IsRequestSuccess":true}</code>
            </div>
          </div>

          <div class="mt-4">
            <h6 class="text-primary fw-bold">Bill Payment Response — <span class="text-danger">Failure</span></h6>
            <div class="bg-light border rounded p-3 mt-2">
              <code class="text-dark">{"Errors":["Duplicate Reference ID"],"APITransactionID":"","Status":"failed","ConsumerNumber":"","Amount":null,"OperatorID":null,"IsRequestSuccess":false}</code>
            </div>
          </div>

          <h6 class="text-primary fw-bold mt-4">Bill Payment Response Parameters</h6>
          <div class="table-responsive shadow-sm rounded mt-2">
            <table class="table table-bordered align-middle mb-0">
              <thead class="table-light">
                <tr><th>Parameter Name</th><th>Details</th></tr>
              </thead>
              <tbody>
                <tr><td><b>APITransactionID</b></td><td><span class="text-danger fw-bold">164</span> <small class="text-muted">— Unique transaction ID</small></td></tr>
                <tr><td><b>Status</b></td>
                  <td>
                    <span class="badge bg-success">success</span>
                    <span class="badge bg-danger">failed</span>
                    <span class="badge bg-warning text-dark">pending</span>
                    <small class="text-muted d-block mt-1">Recharge status</small>
                  </td>
                </tr>
                <tr><td><b>ConsumerNumber</b></td><td><span class="text-danger fw-bold">1234567890</span> <small class="text-muted">— Consumer number billed</small></td></tr>
                <tr><td><b>Amount</b></td><td><span class="text-danger fw-bold">100</span> <small class="text-muted">— Amount requested</small></td></tr>
                <tr><td><b>OperatorID</b></td><td><span class="text-danger fw-bold">1</span> <small class="text-muted">— Operator code</small></td></tr>
                <tr><td><b>IsRequestSuccess</b></td><td><span class="text-success fw-bold">true</span> <small class="text-muted">— Indicates request success</small></td></tr>
                <tr><td><b>Errors[]</b></td><td><small class="text-muted">— String array containing any error messages</small></td></tr>
              </tbody>
            </table>
          </div>
        </section>
      </div>
    </div>
  </div>
</div>

<style>
  code {
    font-family: "Fira Code", monospace;
    white-space: pre-wrap;
    word-break: break-word;
  }
  .table th, .table td {
    vertical-align: middle !important;
  }
</style>

@endsection
