<?php

namespace App\Http\Controllers\web;

use Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Redirect;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;


use App\Models\User;


class LoginController extends Controller
{

    public function login()
    {
        // return view('login');
        if (Auth::check()) {
            if (Auth::user()->role == 'admin') {
                return Redirect::to('/admin/dashboard');
            }
            // if (Auth::user()->u_type == 'U') {
            //     return Redirect::to('/users_dashboard');
            // }
            // if (Auth::user()->u_type == 'M') {
            //     return Redirect::to('/member_dashboard');
            // }
        } else {
            return view('login');
        }
    }
    public function dologin(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $res = [];
        if(auth()->attempt(array('email' => $request['email'], 'password' => $request['password'])))
        {
            if (auth()->user()->role == 'admin') {
                $res['msg'] = 'success';
            }else{
                $res['msg'] = 'success';
            }
        }else{
            $res['msg'] = 'invalid';
        }
        return $res;
    }

    public function logout()
    {
        Auth::logout();
        return redirect('/login');
    }

}
